#include<can.h>
#include<p30fxxxx.h>

#if defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) \
    || defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F6010__)

/***************************************************************************
* Function Name     : CAN2IsTXReady
* Description       : This function returns TXREQ bit status which indicates 
*                     whether the transmitter is ready for next transmission.
* Parameters        : char: buffno
* Return Value      : char: compliment of TXREQ bit status 
****************************************************************************/

char CAN2IsTXReady(char buffno)
{  
    switch(buffno)
    {
    case 0:
        return !(C2TX0CONbits.TXREQ);
        break;
    case 1:
        return !(C2TX1CONbits.TXREQ);
        break;
    case 2:
        return !(C2TX2CONbits.TXREQ);
        break;
    }
    return 0;
}

#endif
